USE [EleriumClean]
GO

/****** Object:  Table [dbo].[RewardTransactionBreakdown]    Script Date: 10/3/2013 8:14:10 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[RewardTransactionBreakdown](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectID] [int] NOT NULL,
	[RewardTransactionID] [int] NOT NULL,
	[Points] [money] NOT NULL,
 CONSTRAINT [PK_RewardTransactionBreakdown] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[RewardTransactionBreakdown]  WITH CHECK ADD  CONSTRAINT [FK_RewardTransactionBreakdown_RewardTransaction] FOREIGN KEY([RewardTransactionID])
REFERENCES [dbo].[RewardTransaction] ([ID])
GO

ALTER TABLE [dbo].[RewardTransactionBreakdown] CHECK CONSTRAINT [FK_RewardTransactionBreakdown_RewardTransaction]
GO

EXEC sys.sp_addextendedproperty @name=N'BackrefAccessorName', @value=N'Projects' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RewardTransactionBreakdown', @level2type=N'COLUMN',@level2name=N'ProjectID'
GO

EXEC sys.sp_addextendedproperty @name=N'BackrefAccessorName', @value=N'Breakdowns' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RewardTransactionBreakdown', @level2type=N'COLUMN',@level2name=N'RewardTransactionID'
GO


